<?php
/**
 * Mark Lesson
 *
 * @package     AutomatorWP\Integrations\Tutor_LMS\Actions\Mark_Lesson
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Tutor_LMS_Mark_Lesson extends AutomatorWP_Integration_Action {

    public $integration = 'tutor';
    public $action = 'tutor_mark_lesson';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark lesson as completed for the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark <strong>lesson as completed</strong> for the user', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'edit_label'        => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. %2$s: Operation (completed or not completed). */
            'log_label'         => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Lesson:', 'automatorwp-pro' ),
                    'option_default'    => __( 'lesson', 'automatorwp-pro' ),
                    'placeholder'       => __( 'Select a lesson', 'automatorwp-pro' ),
                    'option_none'       => false,
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Lesson ID', 'automatorwp-pro' ),
                    'post_type'         => apply_filters( 'tutor_lesson_post_type', 'lesson' ),
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $lesson_id = absint( $action_options['post'] );

        // Bail if not course provided
        if( $lesson_id === 0 ) {
            return;
        }

        tutils()->mark_lesson_complete( $lesson_id, $user_id );

    }

}

new AutomatorWP_Tutor_LMS_Mark_Lesson();